% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_bioclim.R
\name{model_bioclim}
\alias{model_bioclim}
\title{model_bioclim Generate Bioclim model}
\usage{
model_bioclim(occs, bg, user.grp, bgMsk, logger = NULL, spN = NULL)
}
\arguments{
\item{occs}{data frame of cleaned or processed occurrences obtained from
components occs: Obtain occurrence data or, poccs: Process occurrence data.}

\item{bg}{coordinates of background points to be used for modeling.}

\item{user.grp}{a list of two vectors containing group assignments for
occurrences (occs.grp) and background points (bg.grp).}

\item{bgMsk}{a RasterStack or a RasterBrick of environmental layers cropped
and masked to match the provided background extent.}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running
in shiny, otherwise leave the default NULL.}

\item{spN}{character. Species name to be used for all logger messages.}
}
\value{
Function returns an ENMevaluate object with all the evaluated models
  and a selection of appropriate fields.
}
\description{
The function generates a BIOCLIM model using
  ENMeval 2.0
}
\details{
The function generates a model in ENMeval using a user provided partition of
  occurrences from previous components in the GUI.
}
\examples{
\dontrun{
envs <- envs_userEnvs(rasPath = list.files(system.file("extdata/wc",
                                           package = "wallace"),
                      pattern = ".tif$", full.names = TRUE),
                      rasName = list.files(system.file("extdata/wc",
                                           package = "wallace"),
                      pattern = ".tif$", full.names = FALSE))
occs <- read.csv(system.file("extdata/Bassaricyon_alleni.csv",
                 package = "wallace"))
bg <- read.csv(system.file("extdata/Bassaricyon_alleni_bgPoints.csv",
               package = "wallace"))
partblock <- part_partitionOccs(occs, bg, method = 'block')
m <- model_bioclim(occs, bg, partblock, envs)
}

}
\seealso{
\code{\link[ENMeval]{ENMevaluate}}
}
\author{
Jamie M. Kass <jkass@gradcenter.cuny.edu>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>
}
