% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envs_ecoClimate.R
\name{ecoClimate_select}
\alias{ecoClimate_select}
\title{ecoClimate_select}
\usage{
ecoClimate_select(map_climate, Sels=c(1:19), extent=c(-180, 180, -90, 90))
}
\arguments{
\item{map_climate}{raster stack with all the variables}

\item{Sels}{vector of integer numbers. 1 for bio1, 2 for bio2, etc. e.g. Sels= c(1,12,6) for selecting bio1, bio12 and bio6}

\item{extent}{vector. xmin, xmax, ymin, ymax. e.g. c()}
}
\description{
select which bioclimatic variables and set the extent you want (crop the raster stack to your study extent)
}
\examples{
\dontrun{
CCSM_mod_present <- ecoclimate_getdata("CCSM", "Modern", "Present")
Europe_CCSM_m_p_bio1_12 <- ecoClimate_select(CCSM_mod_present, c(1, 12),
                                             extent = c(-20, 80, 20, 80))
dev.new()
plot(Europe_CCSM_m_p_bio1_12)
}


}
