// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1
#include <stan/model/model_header.hpp>
namespace model_rw1_model_naive_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_rw1_model_naive");
    reader.add_event(46, 44, "end", "model_rw1_model_naive");
    return reader;
}
#include <stan_meta_header.hpp>
class model_rw1_model_naive : public prob_grad {
private:
        int k;
        int n;
        matrix_d xreg;
        vector_d y;
        vector_d beta_mean;
        vector_d beta_sd;
        vector_d sigma_mean;
        vector_d sigma_sd;
        vector_d sigma_b_mean;
        vector_d sigma_b_sd;
        double sigma_y_mean;
        double sigma_y_sd;
public:
    model_rw1_model_naive(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_rw1_model_naive(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_rw1_model_naive_namespace::model_rw1_model_naive";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 4;
            validate_non_negative_index("xreg", "k", k);
            validate_non_negative_index("xreg", "n", n);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(k,n));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = n;
            size_t xreg_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("beta_mean", "k", k);
            context__.validate_dims("data initialization", "beta_mean", "vector_d", context__.to_vec(k));
            beta_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            size_t beta_mean_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_mean_j_1_max__; ++j_1__) {
                beta_mean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("beta_sd", "k", k);
            context__.validate_dims("data initialization", "beta_sd", "vector_d", context__.to_vec(k));
            beta_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            size_t beta_sd_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_sd_j_1_max__; ++j_1__) {
                beta_sd(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_mean", "vector_d", context__.to_vec((k + 1)));
            sigma_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_mean");
            pos__ = 0;
            size_t sigma_mean_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_mean_j_1_max__; ++j_1__) {
                sigma_mean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_sd", "vector_d", context__.to_vec((k + 1)));
            sigma_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_sd");
            pos__ = 0;
            size_t sigma_sd_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_sd_j_1_max__; ++j_1__) {
                sigma_sd(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            current_statement_begin__ = 13;
            validate_non_negative_index("sigma_b_mean", "k", k);
            sigma_b_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_mean, DUMMY_VAR__);
            stan::math::assign(sigma_b_mean,stan::model::rvalue(sigma_mean, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_mean"));
            current_statement_begin__ = 14;
            validate_non_negative_index("sigma_b_sd", "k", k);
            sigma_b_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_sd, DUMMY_VAR__);
            stan::math::assign(sigma_b_sd,stan::model::rvalue(sigma_sd, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_sd"));
            current_statement_begin__ = 15;
            sigma_y_mean = double(0);
            stan::math::fill(sigma_y_mean, DUMMY_VAR__);
            stan::math::assign(sigma_y_mean,get_base1(sigma_mean, 1, "sigma_mean", 1));
            current_statement_begin__ = 16;
            sigma_y_sd = double(0);
            stan::math::fill(sigma_y_sd, DUMMY_VAR__);
            stan::math::assign(sigma_y_sd,get_base1(sigma_sd, 1, "sigma_sd", 1));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 20;
            validate_non_negative_index("sigma_b", "k", k);
            num_params_r__ += (1 * k);
            current_statement_begin__ = 21;
            num_params_r__ += 1;
            current_statement_begin__ = 22;
            validate_non_negative_index("beta_raw", "k", k);
            validate_non_negative_index("beta_raw", "n", n);
            num_params_r__ += (k * n);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_rw1_model_naive() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 20;
        if (!(context__.contains_r("sigma_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_b");
        pos__ = 0U;
        validate_non_negative_index("sigma_b", "k", k);
        context__.validate_dims("parameter initialization", "sigma_b", "double", context__.to_vec(k));
        std::vector<double> sigma_b(k, double(0));
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            sigma_b[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_b_i_0_max__ = k;
        for (size_t i_0__ = 0; i_0__ < sigma_b_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_b[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_b: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("sigma_y")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_y missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_y", "double", context__.to_vec());
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_y);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 22;
        if (!(context__.contains_r("beta_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "k", k);
        validate_non_negative_index("beta_raw", "n", n);
        context__.validate_dims("parameter initialization", "beta_raw", "matrix_d", context__.to_vec(k,n));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_raw(k, n);
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                beta_raw(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(beta_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 20;
            std::vector<local_scalar_t__> sigma_b;
            size_t sigma_b_d_0_max__ = k;
            sigma_b.reserve(sigma_b_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_b.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_b.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 21;
            local_scalar_t__ sigma_y;
            (void) sigma_y;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_y = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_y = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 22;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta_raw;
            (void) beta_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_raw = in__.matrix_constrain(k, n, lp__);
            else
                beta_raw = in__.matrix_constrain(k, n);
            // transformed parameters
            current_statement_begin__ = 26;
            validate_non_negative_index("beta", "k", k);
            validate_non_negative_index("beta", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta(k, n);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("tmp", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(k);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 29;
            stan::model::assign(beta, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        add(beta_mean, elt_multiply(beta_sd, stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"))), 
                        "assigning variable beta");
            current_statement_begin__ = 30;
            for (int t = 2; t <= n; ++t) {
                current_statement_begin__ = 31;
                stan::math::assign(tmp, stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "beta"));
                current_statement_begin__ = 32;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(tmp, elt_multiply(to_vector(sigma_b), stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_raw"))), 
                            "assigning variable beta");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 26;
            size_t beta_j_1_max__ = k;
            size_t beta_j_2_max__ = n;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(beta(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 28;
            size_t tmp_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tmp(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tmp" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tmp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 37;
            lp_accum__.add(normal_log<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
            current_statement_begin__ = 38;
            lp_accum__.add(normal_log<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
            current_statement_begin__ = 39;
            lp_accum__.add(normal_log<propto__>(to_vector(beta_raw), 0, 1));
            {
            current_statement_begin__ = 41;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            stan::math::assign(mu,columns_dot_product(xreg, beta));
            current_statement_begin__ = 42;
            lp_accum__.add(normal_log<propto__>(y, mu, sigma_y));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_b");
        names__.push_back("sigma_y");
        names__.push_back("beta_raw");
        names__.push_back("beta");
        names__.push_back("tmp");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_rw1_model_naive_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> sigma_b;
        size_t sigma_b_d_0_max__ = k;
        sigma_b.reserve(sigma_b_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
            sigma_b.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_b[k_0__]);
        }
        double sigma_y = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_y);
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_raw = in__.matrix_constrain(k, n);
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                vars__.push_back(beta_raw(j_1__, j_2__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 26;
            validate_non_negative_index("beta", "k", k);
            validate_non_negative_index("beta", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta(k, n);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("tmp", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tmp(k);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 29;
            stan::model::assign(beta, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        add(beta_mean, elt_multiply(beta_sd, stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"))), 
                        "assigning variable beta");
            current_statement_begin__ = 30;
            for (int t = 2; t <= n; ++t) {
                current_statement_begin__ = 31;
                stan::math::assign(tmp, stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "beta"));
                current_statement_begin__ = 32;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(tmp, elt_multiply(to_vector(sigma_b), stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_raw"))), 
                            "assigning variable beta");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t beta_j_2_max__ = n;
                size_t beta_j_1_max__ = k;
                for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                        vars__.push_back(beta(j_1__, j_2__));
                    }
                }
                size_t tmp_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                    vars__.push_back(tmp(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    static std::string model_name() {
        return "model_rw1_model_naive";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_j_2_max__ = n;
            size_t beta_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t tmp_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_j_2_max__ = n;
            size_t beta_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t tmp_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_rw1_model_naive_namespace::model_rw1_model_naive stan_model;
#endif
