% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_wal.R
\name{readWAL}
\alias{readWAL}
\title{Read bitmap image in WAL format, returning image data only.}
\usage{
readWAL(filepath, apply_palette = wal::pal_q2())
}
\arguments{
\item{filepath}{character string, path to the file including extension}

\item{apply_palette}{optional 256 x 3 integer matrix, the palette. Must contain values in range 0..255. Pass NULL if you do not want to apply any palette. The resulting \code{wal} object will not have an 'image' entry then.}
}
\value{
numeric matrix with dimension width x height x channels, with all color values in range 0..1.
}
\description{
Read a bitmap image in WAL format, and return data in the same format as \code{png::readPNG} and \code{jpeg::readJPEG} do.
}
\examples{
\dontrun{
   walf = '~/data/q2_pak0_extracted/textures/e1u2/basic1_7.wal';
   wal_image = readWAL(walf);
   dim(wal_image);
}

}
\seealso{
\code{read.wal} if you want to read the header and have more control.
}
