% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtree.R
\name{vtree}
\alias{vtree}
\title{vtree: Draw a variable tree}
\usage{
vtree(z, vars, showempty = FALSE, title = "", prune = list(),
  prunebelow = list(), keep = list(), follow = list(),
  labelnode = list(), labelvar = NULL, text = list(),
  check.is.na = FALSE, nodefunc = NULL, nodeargs = NULL,
  HTMLtext = FALSE, showlevels = TRUE, levelshape = "none",
  digits = 0, splitwidth = 20, color = c("blue", "forestgreen",
  "red", "orange", "pink"), colornodes = FALSE,
  fillcolor = rep(c("#EFF3FF", "#C6DBEF", "#9ECAE1", "#6BAED6",
  "#4292C6", "#2171B5", "#084594"), 8), fillnodes = TRUE,
  getscript = FALSE, nodesep = 0.5, ranksep = 0.5, vp = TRUE,
  root = 1, last = 1, top = TRUE, horiz = TRUE, rounded = TRUE,
  summary = "", leafonly = FALSE, width = NULL, height = NULL)
}
\arguments{
\item{z}{Data frame, or a single vector.}

\item{vars}{Either a character string of space-separated variable names
or a vector variable names. (Does not need to be specified if \code{z} is a vector.)}

\item{showempty}{Show empty (N=0) nodes?}

\item{title}{title for the top node of the tree. (If not specified "Sample" will be shown.)}

\item{prune}{List of vectors to identify nodes to prune.
The name of each element of the
list is one of the variable names in \code{vars}.
Each element is a vector of character strings identifying values of the variable (nodes) to prune.}

\item{prunebelow}{Same as prune but the nodes themselves are not pruned, just their descendants.}

\item{keep}{Which nodes should be kept (i.e. not pruned).}

\item{follow}{Which nodes should be "followed".
Here, "followed" means that the descendants of a node (and their descendants, etc.) will be shown.}

\item{labelnode}{List of vectors used to change how variable values are displayed.
The name of each element of the
list is one of the variable names in \code{vars}.
Each element of the list is a vector of character strings.
The character strings represent the existing levels of the variable.
The names of the vector represent the corresponding new levels of the variable.}

\item{labelvar}{a named vector of labels for labeling nodes.
Each element is a header for nodes of the corresponding variable.}

\item{text}{A list of vectors used to specify extra text to add to certain nodes.
(See Details for text formatting.)}

\item{check.is.na}{Replace each variable with a logical vector indicating whether or not each of its values is missing.
This is one case where \code{vtree} can use continuous variables.}

\item{nodefunc}{A node function.}

\item{nodeargs}{A list containing arguments for the node function.}

\item{HTMLtext}{Is the text formatted in HTML?}

\item{showlevels}{Show the names of the variables at each level?}

\item{levelshape}{The shape of the boxes showing the levels of the tree}

\item{digits}{Number of decimal digits to show in percentages}

\item{splitwidth}{The minimum number of characters before an automatic linebreak is created.}

\item{color}{A vector of color names for the outline of the nodes at each level (see Graphviz `color` attribute).}

\item{colornodes}{Should the node boxes be colored?}

\item{fillcolor}{A vector of color names for filling the nodes at each level (see Graphviz `fillcolor` attribute).}

\item{fillnodes}{Should the nodes be filled with color?}

\item{getscript}{Instead of displaying the flowchart, return the DOT script as a character string?}

\item{nodesep}{Graphviz attribute: Node separation amount}

\item{ranksep}{Graphviz attribute: Rank separation amount}

\item{vp}{Use "valid percentages"?
Valid percentages are computed by first excluding any missing values,
i.e. restricting attention to the set of "valid" observations.
The denominator is thus the number of non-missing observations.
When \code{vp=TRUE}, nodes for missing values show the number of missing values
but do not show a percentage. The other nodes show valid percentages.
When \code{vp=FALSE}, all nodes (including nodes for missing values)
show percentages of the total number of observations.}

\item{root}{Is this the root node?}

\item{last}{Is this the last node?}

\item{top}{Is this the top?}

\item{horiz}{Should the tree be drawn horizontally? (i.e. root node on the left, with the tree growing to the right)}

\item{rounded}{Should the nodes have rounded boxes?}

\item{summary}{A character string used to specify summary statistics to display in each node.
The first word in the character string is the name of the variable to be summarized.
The rest of the character string is the the string that will be displayed,
in which special codes are transformed into summary statistics, etc.
See Details for the special codes.}

\item{leafonly}{Should the summary information only be shown in leaf nodes?}

\item{width}{width to be passed to grViz}

\item{height}{height to be passed to grViz}
}
\description{
vtree is a tool for drawing variable trees.
Variable trees display information about nested subsets of a data frame,
in which the subsetting is defined by the values of categorical variables.
}
\details{
Special codes for the \code{summary} argument:
\itemize{
 \item{\code{\%mean\%} }{mean}
 \item{\code{\%SD\%} }{standard deviation}
 \item{\code{\%min\%} }{minimum}
 \item{\code{\%max\%} }{maximum}
 \item{\code{\%pX\%} }{Xth percentile, e.g. p50 means the 50th percentile}
 \item{\code{\%median\%} }{median, i.e. p50}
 \item{\code{\%IQR\%} }{interquartile range, i.e. p25, p75}
 \item{\code{\%list\%} }{list of the individual values}
 \item{\code{\%mv\%} }{the number of missing values}
 \item{\code{\%v\%} }{the name of the variable}
 \item{\code{\%noroot\%} }{flag: Do not show summary in the root node.}
 \item{\code{\%leafonly\%} }{flag: Only show summary in leaf nodes.}
}

Formatting codes for the \code{text} argument.
Also used by \code{labelnode} and \code{labelvar}.
\itemize{
 \item{\code{\\n} }{line break}
 \item{\code{*...*} }{italics}
 \item{\code{**...**} }{bold}
 \item{\code{^...^} }{superscript (using 10 point font)}
 \item{\code{~...~} }{subscript (using 10 point font)}
 \item{\code{\%\%red ...\%\%} }{display text in red (or whichever color is specified)}
}
}
\examples{
# A single-level hierarchy
vtree(FakeData,"Severity")

# A two-level hierarchy
vtree(FakeData,"Severity Sex")

# A two-level hierarchy with pruning of some values of Severity
vtree(FakeData,"Severity Sex",prune=list("Severity"=c("Moderate","NA")))

# Rename some nodes
vtree(FakeData,"Severity Sex",labelnode=list(Sex=(c("Male"="M","Female"="F"))))

}
\author{
Nick Barrowman <nbarrowman@cheo.on.ca>
}
