% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plotting.R
\name{m_scatter}
\alias{m_scatter}
\title{Generates a matrix of scatter plots}
\usage{
m_scatter(
  data,
  data_type = "dat",
  lookup = NULL,
  yr = 1,
  popn = 1,
  param = "N",
  vs = NA,
  save2disk = TRUE,
  fname = NULL,
  dir_out = "Plots"
)
}
\arguments{
\item{data}{The output from \code{collate_dat}, the long format of the
output from \code{collate_run} or the output from \code{con_l_yr}}

\item{data_type}{The type of input data. Possible options are 'dat', 'yr' or 'run'}

\item{lookup}{A table to add relevant variable matched using the scenarios
names}

\item{yr}{The year to be plotted}

\item{popn}{The sequential number of the population (in integer)}

\item{param}{The parameter to be plotted in the last raw}

\item{vs}{The parameters to be plotted}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{fname}{The name of the files where to save the output}

\item{dir_out}{The local path to store the output. Default: Plots}
}
\value{
A matrix of scatter plots
}
\description{
\code{m_scatter} generates a matrix of pairwise scatter plots to graphically
investigate possible associations between variables.
}
\details{
The output from \code{collate_dat} is the preferred input for this function
as large datasets will require a long time to be plotted.

It may be convenient to pass the dependent variable of a regression model
with \code{param} so that all the pairwise scatter plots of this variable
will be in one line.
}
\examples{
# Using Pacioni et al. example data. See ?pac.lhs for more details.
data(pac.lhs)
# Remove base scenario
pac.lhs.no.base <- pac.lhs[!pac.lhs$scen.name == 'ST_LHS(Base)', ]

# Get correct parameter values at year 0
lkup.ST_LHS <- lookup_table(
    data=pac.lhs.no.base, project='Pacioni_et_al',
    scenario='ST_LHS',
    pop='Population 1',
    SVs=c('SV1', 'SV2', 'SV3', 'SV4', 'SV5', 'SV6', 'SV7'),
    save2disk=FALSE)

scatter.plot <- m_scatter(
    data=pac.lhs.no.base[1:33],
    data_type='dat',
    lookup=lkup.ST_LHS,
    yr=120,
    popn=1,
    param='Nall',
    vs=c('SV1', 'SV2', 'SV3'),
    save2disk=FALSE)
}
