% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deseq_2x3_polar.R
\name{deseq_2x3_polar}
\alias{deseq_2x3_polar}
\title{Convert 2x3 design DESeq2 objects to a volcano3d object}
\usage{
deseq_2x3_polar(
  object,
  pcutoff = 0.05,
  fc_cutoff = NULL,
  padj.method = "BH",
  process = c("positive", "negative", "two.sided"),
  scheme = c("grey60", "red", "gold2", "green3", "cyan", "blue", "purple", "black"),
  labs = NULL
)
}
\arguments{
\item{object}{A named list of 3 objects of class 'DESeqDataSet', or a list of
3 DESeq2 results dataframes generated by calling \code{DESeq2::results()}. Each
object should contain the binary outcome comparison for each of the 3
groups, e.g. group A response vs non-response, group B response vs
non-response, group C etc. The names of the groups are taken from the list
names.}

\item{pcutoff}{Cut-off for p-value significance}

\item{fc_cutoff}{Cut-off for fold change on radial axis}

\item{padj.method}{Can be \code{"qvalue"} or any method available in \code{p.adjust}.
The option \code{"none"} is a pass-through.}

\item{process}{Character value specifying colour process for statistical
significant genes: "positive" specifies genes are coloured if fold change
is >0; "negative" for genes with fold change <0 (note that for clarity the
polar position is altered so that genes along each axis have the most
strongly negative fold change values); or "two.sided" which is a compromise
in which positive genes are labelled as before but genes with negative fold
changes and significant p-values have an inverted colour scheme.}

\item{scheme}{Vector of colours starting with non-significant genes/variables}

\item{labs}{Optional character vector for labelling groups. Default \code{NULL}
leads to abbreviated labels based on levels in \code{outcome} using
\code{\link[=abbreviate]{abbreviate()}}. A vector of length 3 with custom abbreviated names for the
outcome levels can be supplied. Otherwise a vector length 8 is expected, of
the form "ns", "A+", "A+B+", "B+", "B+C+", "C+", "A+C+", "A+B+C+", where
"ns" means non-significant and A, B, C refer to levels 1, 2, 3 in
\code{outcome}, and must be in the correct order.}
}
\value{
Returns an S4 'volc3d' object containing:
\itemize{
\item{'df'} A list of 2 dataframes. Each dataframe contains both x,y,z
coordinates as well as polar coordinates r, angle. The first dataframe has
coordinates based on the DESeq2 statistic. The 2nd dataframe is unscaled
and represents log2 fold change for gene expression. The \code{type} argument in
\code{\link{volcano3D}}, \code{\link{radial_plotly}} and
\code{\link{radial_ggplot}} corresponds to these dataframes.
\item{'outcome'} An empty factor whose levels are the three-group contrast
factor for comparisons
\item{'data'} Empty dataframe for compatibility
\item{'pvals'} A dataframe containing p-values. Columns 1-3 are pairwise
comparisons between the outcome factor for groups A, B, C respectively.
\item{'padj'} A dataframe containing p-values adjusted for multiple testing
\item{'pcutoff} Numeric value for cut-off for p-value significance
\item{'scheme'} Character vector with colour scheme for plotting
\item{'labs'} Character vector with labels for colour groups
}
}
\description{
This function is used instead of \code{\link{polar_coords}} if you have raw
RNA-Seq count data. It takes results from a 2x3 design DESeq2 analysis using
\code{\link[=deseq_2x3]{deseq_2x3()}}. Alternatively it will accept a list of 3 \code{DESeqDataSet} or
\code{DESeqResults} objects each with the same type of binary comparison across 3
groups. Statistical results are extracted and converted to a 'volc3d' object,
which can be directly plotted. Example usage would include comparing gene
expression against a binary outcome e.g. response vs non-response, across 3
drugs.
}
\details{
This function generates a 'volc3d' class object for visualising a 2x3 way
analysis for RNA-Seq data. For usual workflow it is typically preceded by a
call to \code{\link[=deseq_2x3]{deseq_2x3()}} which runs the 3x DESeq2 analyses required.

Scaled polar coordinates are based on the DESeq2 statistic for each group
comparison. Unscaled polar coordinates are generated using the log2 fold
change for each group comparison.

The z axis for 3d volcano plots does not have as clear a corollary in 2x3
analysis as for the standard 3-way analysis (which uses the likelihood ratio
test for the 3 groups). For 2x3 polar analysis the smallest p-value from the
3 group pairwise comparisons for each gene is used to generate a z coordinate
as -log10(p-value).

The colour scheme is not as straightforward as for the standard polar plot
and volcano3D plot since genes (or attributes) can be significantly up or
downregulated in the response comparison for each of the 3 groups.
\code{process = "positive"} means that genes are labelled with colours if a gene
is significantly upregulated in the response for that group. This uses the
primary colours (RGB) so that if a gene is upregulated in both red and blue
groups it becomes purple etc with secondary colours. If the gene is
upregulated in all 3 groups it is labelled black. Non-significant genes are
in grey.

With \code{process = "negative"} genes are coloured when they are significantly
downregulated. With \code{process = "two.sided"} the colour scheme means that both
significantly up- and down-regulated genes are coloured with downregulated
genes labelled with inverted colours (i.e. cyan is the inverse of red etc).
However, significant upregulation in a group takes precedence.
}
\seealso{
\code{\link[=deseq_2x3]{deseq_2x3()}}
}
