% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deseq_polar.R
\name{deseq_polar}
\alias{deseq_polar}
\title{Convert DESeq2 objects to a volcano3d object}
\usage{
deseq_polar(
  object,
  objectLRT,
  contrast,
  data = NULL,
  pcutoff = 0.05,
  padj.method = "BH",
  filter_pairwise = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class 'DESeqDataSet' with the full design formula.
The function `DESeq` needs to have been run.}

\item{objectLRT}{An object of class 'DESeqDataSet' with the reduced design
formula. The function `DESeq` needs to have been run on this object with
argument `test="LRT"`.}

\item{contrast}{Character value specifying column within the metadata stored
in the DESeq2 dataset objects is the outcome variable. This column must 
contain a factor with 3 levels.}

\item{data}{Optional matrix containing gene expression data. If not supplied,
the function will pull the expression data from within the DESeq2 object
using the DESeq2 function `assay()`. NOTE: for consistency with gene
expression datasets, genes are in rows.}

\item{pcutoff}{Cut-off for p-value significance}

\item{padj.method}{Can be any method available in `p.adjust` or `"qvalue"`.
The option "none" is a pass-through.}

\item{filter_pairwise}{Logical whether adjusted p-value pairwise statistical
tests are only conducted on genes which reach significant adjusted p-value
cut-off on the group likelihood ratio test}

\item{...}{Optional arguments passed to [polar_coords()]}
}
\description{
This function takes 2 `DESeqDataSet` objects and converts the results to a
'volc3d' object.
}
\examples{

\dontrun{
  library(DESeq2)

  counts <- matrix(rnbinom(n=1500, mu=100, size=1/0.5), ncol=15)
  cond <- factor(rep(1:3, each=5), labels = c('A', 'B', 'C'))

  # object construction
  dds <- DESeqDataSetFromMatrix(counts, DataFrame(cond), ~ cond)

  # standard analysis
  dds <- DESeq(dds)

  # Likelihood ratio test
  ddsLRT <- DESeq(dds, test="LRT", reduced= ~ 1)

  polar <- deseq_polar(dds, ddsLRT, "cond")
  volcano3D(polar)
  radial_ggplot(polar)
}

}
