% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_coords.R
\docType{class}
\name{polar-class}
\alias{polar-class}
\title{An S4 class to define the polar coordinates and pvalues for polar
differential expression plots}
\description{
An S4 class to define the polar coordinates and pvalues for polar
differential expression plots
}
\section{Slots}{

\describe{
\item{\code{sampledata}}{Sample data with ID and contrast column.}

\item{\code{contrast}}{The column name in `sampledata`` which contains the
three-group contrast factor used for comparisons.}

\item{\code{pvalues}}{A data frame containing the p-values, and adjusted p-values,
for all three comparisons between groups in the 
contrast factor, as well as optional fold changes and multi-group tests.}

\item{\code{multi_group_test}}{Column name prefix for statistical tests between
all three groups}

\item{\code{expression}}{A data frame or matrix containing the expression data. This 
is used to calculate z-score and fold change, therefore it should be a 
normalised expression object such as log transformed or variance stabilised.}

\item{\code{polar}}{A data frame containing:
\itemize{
    \item The axis score or mean expression for each of the three groups 
    in comparison
    \item The z-score polar coordinates: 'y_zscore', 'x_zscore' and 
    'r_zscore'
    \item The fold-change polar coordinates: 'y_fc', 'x_fc' and 'r_fc'
    \item 'angle': The angle in radians for polar coordinates
    \item 'angle_degrees': The angle in degrees
    \item 'max_exp': The group with the highest expression
    \item 'sig': The significance category
}}

\item{\code{non_sig_name}}{The category name for variables which are not significant}
}}

