% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tbeg.R
\name{get_tbeg}
\alias{get_tbeg}
\title{Time beginning}
\usage{
get_tbeg(x)
}
\arguments{
\item{x}{A data frame in RTTM standard. See 'voice::read_rttm'.}
}
\value{
Numeric vector containing the time beginning in seconds.
}
\description{
Get time beginning from a data frame in RTTM standard.
}
\examples{
library(voice)

url0 <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/rttm/sherlock0.rttm'
download.file(url0, destfile = paste0(tempdir(), '/sherlock0.rttm'))

rttm <- voice::read_rttm(tempdir())
(gtb <- voice::get_tbeg(rttm$sherlock0.rttm))
class(gtb)
}
