% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_anova_assumptions.R
\name{vis_anova_assumptions}
\alias{vis_anova_assumptions}
\title{Visualisation of the normality distribution of the standardised residuals of the ANOVA}
\usage{
vis_anova_assumptions(
  samples,
  fact,
  conf.level = 0.95,
  samplename = "",
  factorname = "",
  cex = 1
)
}
\arguments{
\item{samples}{vector containing dependent variable, datatype numeric}

\item{fact}{vector containing independent variable, datatype factor}

\item{conf.level}{confidence level, 0.95=default}

\item{samplename}{name of sample used in graphical output, dataype character
, ''=default}

\item{factorname}{name of sample used in graphical output, dataype character,
''=default}

\item{cex}{number indicating the amount by which plotting text and symbols
should be scaled relative to the default. 1=default, 1.5 is 50\% larger,
0.5 is 50\% smaller, etc.}
}
\value{
\code{list} containing the test statistics of the anova, the p values
  generated by the Shapiro-Wilk test \code{shapiro.test()}, the
  Anderson-Darling test \code{ad.test()} and the \code{bartlett.test()}.
}
\description{
\code{vis_anova_assumptions} checks for normality of the standardised
residuals of the ANOVA. Both the Shapiro-Wilk test \code{shapiro.test()} and
the Anderson-Darling test \code{ad.test()} check the null that the
standardised residuals are normally distributed. It generates a scatter plot
of the standardised residuals versus the fitted mean values of the linear
models for each level of \code{fact}. Furthermore a normal QQ plot of the
standardised residuals is generated. The null of homogeneity of variances  of
each factor level is tested with the \code{bartlett.test()}.
}
\examples{
ToothGrowth$dose <- as.factor(ToothGrowth$dose)
vis_anova_assumptions(ToothGrowth$len, ToothGrowth$dose)

vis_anova_assumptions(ToothGrowth$len, ToothGrowth$supp)
vis_anova_assumptions(iris$Petal.Width, iris$Species)

}
