% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visLayout.R
\name{visLayout}
\alias{visLayout}
\title{Network visualization layout options}
\usage{
visLayout(graph, randomSeed = NULL, improvedLayout = NULL,
  hierarchical = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{randomSeed}{: Number. When NOT using the hierarchical layout, the nodes are randomly positioned initially. This means that the settled result is different every time. If you provide a random seed manually, the layout will be the same every time. Ideally you try with an undefined seed, reload until you are happy with the layout and use the getSeed() method to ascertain the seed.}

\item{improvedLayout}{: Boolean. Default to true. When enabled, the network will use the Kamada Kawai algorithm for initial layout. For networks larger than 100 nodes, clustering will be performed automatically to reduce the amount of nodes. This can greatly improve the stabilization times. If the network is very interconnected (no or few leaf nodes), this may not work and it will revert back to the old method. Performance will be improved in the future.}

\item{hierarchical}{: Boolean. Default to false. When true, the layout engine positions the nodes in a hierarchical fashion using default settings. For customization you can use \link{visHierarchicalLayout}}
}
\description{
Network visualization layout options. For full documentation, have a look at \link{visDocumentation}.
}
\examples{

nodes <- data.frame(id = 1:10)
edges <- data.frame(from = round(runif(8)*10), to = round(runif(8)*10))

visNetwork(nodes, edges) \%>\%
 visLayout(randomSeed = 123) 
 
visNetwork(nodes, edges) \%>\%
 visLayout(hierarchical = TRUE) 
 
visNetwork(nodes, edges) \%>\%
 visHierarchicalLayout(direction = "LR")

}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
