% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice_diffs}
\alias{slice_diffs}
\alias{slice_diffs_both}
\title{Show rows which have differing values in a comparison}
\usage{
slice_diffs(table, comparison, column = everything())

slice_diffs_both(table_a, table_b, comparison, column = everything())
}
\arguments{
\item{table}{A data frame. One of \code{table_a} or \code{table_b} used to
create \code{comparison}}

\item{comparison}{The output of \code{compare()}}

\item{column}{<\code{\link[=versus_tidy_select]{tidy-select}}>. A row will be in the output of slice functions if
the comparison shows differing values for any columns matching this argument}

\item{table_a}{The data frame\code{table_a} used to create \code{comparison}}

\item{table_b}{The data frame\code{table_b} used to create \code{comparison}}
}
\value{
\item{\code{slice_diffs()}}{The input \code{table} is filtered to only the rows for which
\code{comparison} shows differing values for one of the columns in the supplied
\code{column} argument}
\item{\code{slice_diffs_both()}}{The output of \code{slice_diffs()} for both input
tables with the rows interleaved and a column \code{table} indicating which table the row
is from. The output contains only those columns present in both tables.}
}
\description{
Show rows which have differing values in a comparison
}
\examples{
comp <- compare(example_df_a, example_df_b, by = car)
example_df_a |> slice_diffs(comp, disp)
example_df_a |> slice_diffs(comp, c(disp, mpg))
slice_diffs_both(example_df_a, example_df_b, comp, column = disp)
}
