% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_download.R
\name{db_download}
\alias{db_download}
\alias{db_download_eurosl}
\alias{db_download_germansl}
\title{Download taxonomic databases}
\usage{
db_download_eurosl(version = "latest", verbose = TRUE, overwrite = FALSE)

db_download_germansl(version = "latest", verbose = TRUE, overwrite = FALSE)
}
\arguments{
\item{version}{(character) desired version number of the list}

\item{verbose}{(logical) Print messages. Default: `TRUE`}

\item{overwrite}{(logical) If `TRUE` force an update by overwriting
previously downloaded data. Default: `FALSE`}
}
\value{
(character) path to the downloaded SQL database
}
\description{
Download taxonomic databases
}
\details{
Downloads sql database, cleans up unneeded files, returns path
to sql file
}
\examples{
\dontrun{
# EuroSL
# db_download_eurosl()
# src_eurosl()

# GermanSL
# db_download_germansl()
# db_download_germansl(overwrite=TRUE) # overwrite - download again
# src_germansl()

}
}
\seealso{
[tdb_cache]
}
