% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightswitch.R
\name{lightswitch}
\alias{lightswitch}
\alias{turned_off}
\alias{turn_on}
\alias{turned_on}
\alias{turn_off}
\title{Turn vcr on and off, check on/off status, and turn off for a given http call}
\usage{
turned_off(..., ignore_cassettes = FALSE)

turn_on()

turned_on()

turn_off(ignore_cassettes = FALSE)
}
\arguments{
\item{...}{Any block of code to run, presumably an http request}

\item{ignore_cassettes}{(logical) Controls what happens when a cassette is
inserted while vcr is turned off. If \code{TRUE} is passed, the cassette
insertion will be ignored; otherwise an error will be raised.}
}
\description{
Turn vcr on and off, check on/off status, and turn off for a given http call
}
\details{
\itemize{
\item \code{turned_off()} - Turns vcr off for the duration of a block.
\item \code{turn_off()} - Turns vcr off, so that it no longer handles every
HTTP request
\item \code{turn_on()} - turns vcr on
\item \code{turned_on()} - Asks if vcr is turned on, gives a boolean
}
}
\examples{
\dontrun{
vcr_configure(dir = tempdir())

turn_on()
turned_on()
turn_off()

# turn off for duration of a block
library(crul)
turned_off({
 res <- HttpClient$new(url = "https://eu.httpbin.org/get")$get()
})
res

# turn completely off
turn_off()
library(webmockr)
crul::mock()
# HttpClient$new(url = "https://eu.httpbin.org/get")$get(verbose = TRUE)
turn_on()
}
}
