% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http_interaction_list.R
\docType{data}
\name{HTTPInteractionList}
\alias{HTTPInteractionList}
\title{HTTPInteractionList class}
\arguments{
\item{interactions}{(list) list of interaction class objects}

\item{request_matchers}{(character) vector of request matchers}

\item{allow_playback_repeats}{whether to allow playback repeats or not}

\item{parent_list}{A list for empty objects, see \link{NullList}}

\item{used_interactions}{(list) Interactions that have been used. That is,
interactions that are on disk in the current cassette, and a
request has been made that matches that interaction}

\item{request}{The request from an object of class \code{HttpInteraction}}
}
\description{
HTTPInteractionList class
}
\details{
\strong{Methods}
\describe{
\item{\code{response_for(request)}}{
Check if there's a matching interaction, returns a response
object
}
\item{\code{has_interaction_matching(request)}}{
Check if has a matching interaction. returns boolean
}
\item{\code{has_used_interaction_matching(request)}}{
check if has used interactions matching a given request.
returns boolean
}
\item{\code{remaining_unused_interaction_count()}}{
Number of unused interactions. returns numeric
}
\item{\code{assert_no_unused_interactions()}}{
Checks if there are no unused interactions left.
returns boolean
}
}
\strong{Private Methods}
\describe{
\item{\code{has_unused_interactions()}}{
Are there areny unused interactions? returns boolean
}
\item{\code{matching_interaction_index_for()}}{
asdfadf
}
\item{\code{matching_used_interaction_for(request)}}{
asdfadfs
}
\item{\code{interaction_matches_request(request, interaction)}}{
Check if a request matches an interaction (logical)
}
\item{\code{from_hash()}}{
Get a hash back.
}
\item{\code{request_summary(z)}}{
Get a request summary (character)
}
\item{\code{response_summary(z)}}{
Get a response summary (character)
}
}
}
\examples{
\dontrun{
vcr_configure(
 dir = tempdir(),
 record = "once"
)

# make interactions
## make the request
### turn off mocking
crul::mock(FALSE)
url <- "https://eu.httpbin.org/post"
cli <- crul::HttpClient$new(url = url)
res <- cli$post(body = list(a = 5))

## request
(request <- Request$new("POST", url, body, res$headers))
## response
(response <- VcrResponse$new(
   res$status_http(),
   res$response_headers,
   res$parse("UTF-8"),
   res$response_headers$status))
## make an interaction
(inter <- HTTPInteraction$new(request = request, response = response))

# make an interactionlist
(x <- HTTPInteractionList$new(
   interactions = list(inter),
   request_matchers = vcr_configuration()$match_requests_on
))
x$interactions
x$request_matchers
x$parent_list
x$parent_list$response_for()
x$parent_list$has_interaction_matching()
x$parent_list$has_used_interaction_matching()
x$parent_list$remaining_unused_interaction_count()
x$used_interactions
x$allow_playback_repeats
x$interactions
x$response_for(request)
}
}
\keyword{datasets}
