% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.stdmean2}
\alias{meta.lm.stdmean2}
\title{Meta-regression analysis for 2-group standardized mean differences}
\usage{
meta.lm.stdmean2(alpha, m1, m2, sd1, sd2, n1, n2, X, stdzr)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for group 1}

\item{m2}{vector of estimated means for group 2}

\item{sd1}{vector of estimated SDs for group 1}

\item{sd2}{vector of estimated SDs for group 2}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{X}{matrix of predictor values}

\item{stdzr}{\itemize{
\item set to 0 for square root unweighted average variance standardizer
\item set to 1 for group 1 SD standardizer
\item set to 2 for group 2 SD standardizer
\item set to 3 for square root weighted average variance standardizer
}}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a 2-group
standardized mean difference. The estimates are OLS estimates with
robust standard errors that accommodate residual heteroscedasticity.
}
\examples{
n1 <- c(65, 30, 29, 45, 50)
n2 <- c(67, 32, 31, 20, 52)
m1 <- c(31.1, 32.3, 31.9, 29.7, 33.0)
m2 <- c(34.1, 33.2, 30.6, 28.7, 26.5)
sd1 <- c(7.1, 8.1, 7.8, 6.8, 7.6)
sd2 <- c(7.8, 7.3, 7.5, 7.2, 6.8)
x1 <- c(4, 6, 7, 7, 8)
X <- matrix(x1, 5, 1)
meta.lm.stdmean2(.05, m1, m2, sd1, sd2, n1, n2, X, 0)

# Should return:
#      Estimate        SE         z p         LL         UL
# b0 -1.6988257 0.4108035 -4.135373 0 -2.5039857 -0.8936657
# b1  0.2871641 0.0649815  4.419167 0  0.1598027  0.4145255


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
