% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{getFIX}
\alias{getFIX}
\alias{getFIX,chromR-method}
\alias{getFIX,vcfR-method}
\alias{getCHROM}
\alias{getCHROM,chromR-method}
\alias{getCHROM,vcfR-method}
\alias{getPOS}
\alias{getPOS,chromR-method}
\alias{getPOS,vcfR-method}
\alias{getQUAL}
\alias{getQUAL,chromR-method}
\alias{getQUAL,vcfR-method}
\alias{getALT}
\alias{getALT,chromR-method}
\alias{getALT,vcfR-method}
\alias{getREF}
\alias{getREF,chromR-method}
\alias{getREF,vcfR-method}
\alias{getID}
\alias{getID,chromR-method}
\alias{getID,vcfR-method}
\alias{getFILTER}
\alias{getFILTER,chromR-method}
\alias{getFILTER,vcfR-method}
\alias{getINFO}
\alias{getINFO,chromR-method}
\alias{getINFO,vcfR-method}
\title{Get elements from the fixed region of a VCF file}
\usage{
getFIX(x, getINFO = FALSE)

getCHROM(x)

getPOS(x)

getQUAL(x)

getALT(x)

getREF(x)

getID(x)

getFILTER(x)

getINFO(x)
}
\arguments{
\item{x}{a vcfR or chromR object}

\item{getINFO}{logical specifying whether getFIX should return the INFO column}
}
\value{
a vector or data frame
}
\description{
Both chromR objects and vcfR objects contain a region with fixed variables.
These accessors allow you to isolate these variables from these objects.
}
\examples{
library("vcfR")
data("vcfR_example")
chrom <- create.chromR('sc50', seq=dna, vcf=vcf, ann=gff)
getFIX(vcf) \%>\% head
getFIX(chrom) \%>\% head

getCHROM(vcf) \%>\% head
getCHROM(chrom) \%>\% head

getPOS(vcf) \%>\% head
getPOS(chrom) \%>\% head

getID(vcf) \%>\% head
getID(chrom) \%>\% head

getREF(vcf) \%>\% head
getREF(chrom) \%>\% head

getALT(vcf) \%>\% head
getALT(chrom) \%>\% head

getQUAL(vcf) \%>\% head
getQUAL(chrom) \%>\% head

getFILTER(vcf) \%>\% head
getFILTER(chrom) \%>\% head

getINFO(vcf) \%>\% head
getINFO(chrom) \%>\% head

}
