% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasta_output.R
\name{write.fasta}
\alias{write.fasta}
\title{Create fasta format output}
\usage{
write.fasta(
  x,
  file = "",
  rowlength = 80,
  tolower = TRUE,
  verbose = TRUE,
  APPEND = FALSE,
  depr = TRUE
)
}
\arguments{
\item{x}{object of class chromR}

\item{file}{name for output file}

\item{rowlength}{number of characters each row should not exceed}

\item{tolower}{convert all characters to lowercase (T/F)}

\item{verbose}{should verbose output be generated (T/F)}

\item{APPEND}{should data be appended to an existing file (T/F)}

\item{depr}{logical (T/F), this function has been deprecated, set to FALSE to override.}
}
\description{
Generate fasta format output
}
\details{
The function \strong{write_fasta} takes an object of class chromR and writes it to a fasta.gz (gzipped text) format file.
The sequence in the seq slot of the chromR object is used to fill in the invariant sites.
The parameter 'tolower', when set to TRUE, converts all the characters in teh sequence to lower case.
This is important because some software, such as ape::DNAbin, requires sequences to be in lower case.
}
