\name{plot.varprd}

\alias{plot.varprd}

\title{Plot method for objects of class varprd}

\description{
  Time Series plots of VAR forecasts with confidence bands for each
  endogenous variable. 
}

\usage{
\method{plot}{varprd}(x, ...)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varprd}}; generated by
    \command{predict.varest()}.}  
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York. 
}

\seealso{
  \code{\link{VAR}}, \code{\link{predict.varest}} 
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
var.2c.prd <- predict(var.2c, n.ahead = 8, ci = 0.95)
plot(var.2c.prd)
}
}

\keyword{regression}
