"irf" <-
function(x, impulse=NULL, response=NULL, n.ahead=10, ortho=TRUE, cumulative=FALSE, boot=TRUE, ci=0.95, runs=100, seed=NULL){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  y.names <- colnames(x$y)
  if(is.null(impulse)){
    impulse <- y.names
  } else {
    impulse <- as.vector(as.character(impulse))
    if(any(!(impulse %in% y.names))) {
      stop("\nPlease provide variables names in impulse\nthat are in the set of endogenous variables.\n")
    }
    impulse <- subset(y.names, subset = y.names %in% impulse)
  }
  if(is.null(response)){
    response <- y.names
  } else {
    response <- as.vector(as.character(response))
    if(any(!(response %in% y.names))){
      stop("\nPlease provide variables names in response\nthat are in the set of endogenous variables.\n")
    }
    response <- subset(y.names, subset = y.names %in% response)
  }
  ## Getting the irf
  irs <- .irf(x = x, impulse = impulse, response = response, y.names = y.names, n.ahead = n.ahead, ortho = ortho, cumulative = cumulative)
  ## Bootstrapping
  Lower <- NULL
  Upper <- NULL
  if(boot){
    ci <- as.numeric(ci)
    if((ci <= 0)|(ci >= 1)){
      stop("\nPlease provide a number between 0 and 1 for the confidence interval.\n")
    }
    ci <- 1 - ci
    BOOT <- .boot(x = x, n.ahead = n.ahead, runs = runs, ortho = ortho, cumulative = cumulative, impulse = impulse, response = response, ci = ci, seed = seed, y.names = y.names)
    Lower <- BOOT$Lower
    Upper <- BOOT$Upper
  }
  result <- list(irf=irs, Lower=Lower, Upper=Upper, response=response, impulse=impulse, ortho=ortho, cumulative=cumulative, runs=runs, ci=ci, boot=boot)
  class(result) <- "varirf"
  return(result)
}
