% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theorical_comparison.R
\name{single_transition_plots}
\alias{single_transition_plots}
\title{single_transition_plots}
\usage{
single_transition_plots(
  value_sets_3L = NULL,
  value_sets_5L = NULL,
  value_sets_XW = NULL,
  value_sets_XWR = NULL,
  graph_title = "",
  x_axis_title = NULL,
  x_min_value = -1,
  x_max_value = 1,
  y_axis_title = "Mean 1-level transition",
  y_min_value = 0,
  y_max_value = 0.5,
  legend_name = NULL
)
}
\arguments{
\item{value_sets_3L}{A character vector specifying the country value sets for the EQ5D-3L version.}

\item{value_sets_5L}{A character vector specifying the country value sets for the EQ5D-5L version.}

\item{value_sets_XW}{A character vector specifying the country value sets for the EQ5D-XW version.}

\item{value_sets_XWR}{A character vector specifying the country value sets for the EQ5D-XWR version.}

\item{graph_title}{A character string specifying the title of the graph. Default is an empty string.}

\item{x_axis_title}{A character string specifying the title of the x-axis. Default is "Utility".}

\item{x_min_value}{A numeric specifying the minimum value for the x-axis. Default is -1.}

\item{x_max_value}{A numeric specifying the maximum value for the x-axis. Default is 1.}

\item{y_axis_title}{A character string specifying the title of the y-axis. Default is "Mean 1-level transition".}

\item{y_min_value}{A numeric specifying the minimum value for the y-axis. Default is 0.}

\item{y_max_value}{A numeric specifying the maximum value for the y-axis. Default is 0.5.}

\item{legend_name}{A character string specifying the name of the legend. Default is NULL.}
}
\value{
A list of ggplot objects visualizing the mean one-level transitions for the specified EQ5D versions and value sets.
}
\description{
This function creates a scatter plot of mean one-level transitions for different EQ5D versions and specified value sets.
}
\note{
This function is primarily intended to work with EQ5D data and it is not be applicable to other instruments.
}
\examples{
single_transition_plots(value_sets_5L = "IT")
single_transition_plots(value_sets_3L = c("JP", "US"))  
single_transition_plots(value_sets_3L ="ES", 
                        value_sets_5L = "ES", 
                        value_sets_XW = "ES", 
                        value_sets_XWR = "ES")        
}
