% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructionModelesLassoMLE.R
\name{constructionModelesLassoMLE}
\alias{constructionModelesLassoMLE}
\title{constructionModelesLassoMLE}
\usage{
constructionModelesLassoMLE(
  phiInit,
  rhoInit,
  piInit,
  gamInit,
  mini,
  maxi,
  gamma,
  X,
  Y,
  eps,
  S,
  ncores,
  fast,
  verbose
)
}
\arguments{
\item{phiInit}{an initialization for phi, get by initSmallEM.R}

\item{rhoInit}{an initialization for rho, get by initSmallEM.R}

\item{piInit}{an initialization for pi, get by initSmallEM.R}

\item{gamInit}{an initialization for gam, get by initSmallEM.R}

\item{mini}{integer, minimum number of iterations in the EM algorithm, by default = 10}

\item{maxi}{integer, maximum number of iterations in the EM algorithm, by default = 100}

\item{gamma}{integer for the power in the penaly, by default = 1}

\item{X}{matrix of covariates (of size n*p)}

\item{Y}{matrix of responses (of size n*m)}

\item{eps}{real, threshold to say the EM algorithm converges, by default = 1e-4}

\item{S}{output of selectVariables.R}

\item{ncores}{Number of cores, by default = 3}

\item{fast}{TRUE to use compiled C code, FALSE for R code only}

\item{verbose}{TRUE to show some execution traces}
}
\value{
a list with several models, defined by phi (the regression parameter reparametrized),
rho (the covariance parameter reparametrized), pi (the proportion parameter is the mixture model), llh
(the value of the loglikelihood function for this estimator on the training dataset). The list is given
for several levels of sparsity, given by several regularization parameters computed automatically.
}
\description{
Construct a collection of models with the Lasso-MLE procedure.
}
