% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{split_by_test}
\alias{split_by_test}
\title{Generic Test-Type Splitting with Suffix Removal}
\usage{
split_by_test(data, metadata_cols = NULL, verbose = TRUE)
}
\arguments{
\item{data}{Data frame. Wide-format test data with columns ending in test
type suffixes (e.g., "PEAK_FORCE_Both_CMJ").}

\item{metadata_cols}{Character vector. Column names to retain as metadata
in each split dataset. Default includes common identifiers and demographics.}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
Named list of data frames, one per test type. Each data frame contains:
  \itemize{
    \item All metadata columns
    \item Test-specific metrics with suffixes removed (e.g., "PEAK_FORCE_Both")
  }
}
\description{
Takes a master wide-format dataset and returns a named list of data frames,
one per test type (e.g., CMJ, DJ, ISO). Crucially, this function automatically
strips the test-type suffix from column names within each sub-dataframe,
enabling generic analysis code that works across all test types.

This implements the "DRY" (Don't Repeat Yourself) principle by allowing
users to write one analysis function that works for any test type.
}
\details{
Split Wide-Format Data by Test Type
}
\examples{
\donttest{
if (FALSE) {
  # After joining tests, trials, and metadata into wide format
  test_datasets <- split_by_test(
    data = final_analysis_data,
    metadata_cols = c("profileId", "sex", "Testdate", "age", "sports")
  )

  # Access individual test datasets
  cmj_data <- test_datasets$CMJ
  dj_data <- test_datasets$DJ

  # Note: Column names are now generic (e.g., "PEAK_FORCE_Both" not "PEAK_FORCE_Both_CMJ")
  # This allows you to write one function that works for all test types
}
}
}
