% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{p.scaled.observation.curves.by.id}
\alias{p.scaled.observation.curves.by.id}
\title{Plot \code{vachette} Transformed Observation Curves by Individual}
\usage{
p.scaled.observation.curves.by.id(vachette_data)
}
\arguments{
\item{vachette_data}{An object of class \code{vachette_data}, which contains
the necessary data for plotting.}
}
\value{
A \code{ggplot2} object representing the \code{vachette} transformed observation curves. The plot
includes different layers for query observations, their transformed counterparts,
and the reference curves, with appropriate color coding and line styles.
}
\description{
This function generates a ggplot2 visualization of transformed observation curves
facetted by individual, including their transformations and overlays
with reference curves. The plot is useful for comparing the original and the \code{vachette}
transformed observation data against typical reference curves.
}
\details{
The function constructs a plot that overlays individual
observation curves with the corresponding reference curves. Query observations
and their transformed curves are highlighted, and if applicable, an extrapolated
segment of the reference curve is shown as a dashed line.

The plot's title includes the model name, and the caption provides details
about the reference covariate(s) used. The x-axis range is dynamically set
based on the minimum and maximum x values, before and after scaling.
}
