% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{utiml_stratified_split}
\alias{utiml_stratified_split}
\title{Labelsets Stratification
Create the indexes using the Labelsets Stratification approach.}
\usage{
utiml_stratified_split(mdata, r)
}
\arguments{
\item{mdata}{A mldr dataset}

\item{r}{Desired proportion of examples in each subset, r1, . . . rk}
}
\value{
A list with k disjoint indexes subsets S1, . . .Sk
}
\description{
Labelsets Stratification
Create the indexes using the Labelsets Stratification approach.
}
\examples{
\dontrun{
# Create 3 partitions for train, validation and test
indexes <- utiml_stratified_split(emotions, c(0.6,0.1,0.3))

# Create a stratified 10-fold
indexes <- utiml_stratified_split(emotions, rep(0.1,10))
}
}
\references{
Sechidis, K., Tsoumakas, G., & Vlahavas, I. (2011). On the
 stratification of multi-label data. In Proceedings of the Machine
 Learningand Knowledge Discovery in Databases - European Conference,
 ECML PKDD (pp. 145-158).
}
