% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{lcard_threshold}
\alias{lcard_threshold}
\alias{lcard_threshold.default}
\alias{lcard_threshold.mlresult}
\title{Threshold based on cardinality}
\usage{
lcard_threshold(prediction, cardinality, probability = FALSE)

\method{lcard_threshold}{default}(prediction, cardinality,
  probability = FALSE)

\method{lcard_threshold}{mlresult}(prediction, cardinality,
  probability = FALSE)
}
\arguments{
\item{prediction}{A matrix or mlresult.}

\item{cardinality}{A real value of training dataset label cardinality, used
to define the threshold value.}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{FALSE})}
}
\value{
A mlresult object.
}
\description{
Find and apply the best threshold based on cardinality of training set.
The threshold is choice based on how much the average observed label
cardinality is close to the average predicted label cardinality.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Cardinality Threshold for matrix or data.frame

\item \code{mlresult}: Cardinality Threshold for mlresult
}}
\examples{
prediction <- matrix(runif(16), ncol = 4)
lcard_threshold(prediction, 2.1)
}
\references{
Read, J., Pfahringer, B., Holmes, G., & Frank, E. (2011). Classifier chains
 for multi-label classification. Machine Learning, 85(3), 333-359.
}
\seealso{
Other threshold: \code{\link{fixed_threshold}},
  \code{\link{mcut_threshold}},
  \code{\link{pcut_threshold}},
  \code{\link{rcut_threshold}},
  \code{\link{scut_threshold}},
  \code{\link{subset_correction}}
}

