% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.decomp.R
\name{sample.decomp}
\alias{sample.decomp}
\title{Sample decomposition}
\usage{
sample.decomp(
  moments = NULL,
  n = NULL,
  sample.mean = NULL,
  sample.sd = NULL,
  sample.var = NULL,
  sample.skew = NULL,
  sample.kurt = NULL,
  names = NULL,
  pooled = NULL,
  skew.type = NULL,
  kurt.type = NULL,
  kurt.excess = NULL,
  include.sd = FALSE
)
}
\arguments{
\item{moments}{A data-frame of moments (an object of class 'moments')}

\item{n}{A vector of sample sizes}

\item{sample.mean}{A vector of sample means}

\item{sample.sd}{A vector of sample standard deviations}

\item{sample.var}{A vector of sample variances}

\item{sample.skew}{A vector of sample skewness}

\item{sample.kurt}{A vector of sample kurotsis}

\item{names}{A vector of names for the sample groups}

\item{pooled}{The number of the pooled group (if the pooled group is already present)}

\item{skew.type}{The type of skewness statistic used ('Moment', 'Fisher Pearson' or 'Adjusted Fisher Pearson')}

\item{kurt.type}{The type of kurtosis statistic used ('Moment', 'Fisher Pearson' or 'Adjusted Fisher Pearson')}

\item{kurt.excess}{Logical value; if \code{TRUE} the sample kurtosis is the excess kurtosis (instead of the raw kurtosis)}

\item{include.sd}{Logical value; if \code{TRUE} the output includes a column for the sample standard deviation (if needed)}
}
\value{
A data-frame of all groups showing their sample sizes and sample moments
}
\description{
\code{sample.decomp} returns the data-frame of sample statistics for sample groups and their pooled sample
}
\details{
It is often useful to take a set of sample groups with known sample statistics and aggregate these into a single pooled sample and find the
sample statistics of the pooled sample.  Likewise, it is sometimes useful to take a set of sample groups and a pooled group with known sample
statistics and determine the statistics of the other group required to complete the pooled sample.  Both of these tasks can be accomplished
using decomposition formulae for the sample size, sample mean and sample variance (or sample standard deviation).  This function implements
either of these two decomposition methods to find the sample statistics of the pooled sample or the other group remaining to obtain the pooled
sample.  The user inputs vectors for the sample size, sample mean and sample variance (or sample standard deviation).  By default the groups
are taken to be separate groups and the function computes the sample statistics for the pooled sample  However, the user can input the number
pooled sample as the input \code{pooled}; in this case that group is treated as the pooled sample and the function computes the other sample
group required to obtain this pooled sample.  The function returns a data-frame showing the sample statistics for all the groups including
the pooled sample.
}
\seealso{
\code{\link{moments}}
}
