% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calc_chunks}
\alias{calc_chunks}
\title{Calculate indices of data "chunks" in a data object}
\usage{
calc_chunks(data = NULL, size = 10, reverse = FALSE)
}
\arguments{
\item{data}{Required. Tibble, data frame, vector.}

\item{size}{Optional. Integer. The number of items (e.g. rows in a tibble)
that make up a given chunk. Must be a positive integer. Defaults to 10 or max.}

\item{reverse}{Optional. Logical. Calculate chunks from back to front.
Defaults to front to back order.}
}
\value{
An iterable list of row indices for each chunk of data.
}
\description{
Calculates chunk indices of a data object
for a given chunk size (number of items per chunk).
}
\examples{
# Create chunk map for a data frame
chunks <- calc_chunks(mtcars, size = 6)

# Iterate through chunks of data
for (chunk in chunks) print(paste0(rownames(mtcars[chunk,]), collapse = ', '))
}
