% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.R
\name{tabulate_model.lm}
\alias{tabulate_model.lm}
\title{Tabulate Model: Linear Regression (LM)}
\usage{
\method{tabulate_model}{lm}(fit, format = TRUE, percent.sign = TRUE,
  digits = 1, p.digits = 4)
}
\arguments{
\item{fit}{Required. lm() object.}

\item{format}{Optional. Logical. Rounds numbers and formats text for a
cleaner, readable output. Defaults to TRUE.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}

\item{p.digits}{Optional. Integer. Number of p-value digits to print. Note that
p-values are still rounded using 'digits'. Defaults to 4.}
}
\description{
Converts parameters from a linear regression model into a usable
table for publication purposes.
}
\examples{
library(dplyr)

data_mtcars <- datasets::mtcars \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate_at(dplyr::vars('vs', 'am'), as.logical) \%>\%
  dplyr::mutate_at(dplyr::vars('gear', 'carb', 'cyl'), as.factor)

tabulate_model(fit = lm(mpg ~ vs + drat + cyl, data = data_mtcars))
}
\seealso{
\code{\link{tabulate_model}}
}
