% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd_endpoints.R
\name{ustfd_tables}
\alias{ustfd_tables}
\title{Return a table of supported and known tables including the API endpoints
for the specified dataset(s). See \code{\link[=ustfd_datasets]{ustfd_datasets()}} for known datasets.}
\source{
\url{https://fiscaldata.treasury.gov/api-documentation/#list-of-endpoints}
}
\usage{
ustfd_tables(datasets = NULL)
}
\arguments{
\item{datasets}{one or more strings representing a valid dataset ID. If
present, only endpoints belonging to matching datasets will be returned}
}
\value{
tibble
}
\description{
\code{ustfd_tables} provides details about 85 known endpoints for Fiscal Data.
A data frame with 85 rows and the following 9 columns:
\itemize{
\item \code{dataset} - ID of the source dataset
\item \code{endpoint} - the table's API endpoint (natural key)
\item \code{table_name} - Name of the table within the data set
\item \code{table_description} - a description for the data in the endpoint
\item \code{row_definition} - a description of what each row in the table describes
\item \code{path_name} - API path name
\item \code{date_column} - the name of the table column that holds the record's date
\item \code{earliest_date} - the date of the earliest record available for this table
\item \code{update_frequency} - "Daily", "Monthly", "Quarterly", "Semi-Annually",
"Annually", "As Needed", "Daily (Discontinued)", "Monthly (Discontinued)"
}
}
\examples{
library(ustfd)
ustfd_tables(ustfd_datasets()$dataset[2])$endpoint



}
\seealso{
Other ustfd_user: 
\code{\link{endpoint_exists}()},
\code{\link{ustfd_all_pages}()},
\code{\link{ustfd_datasets}()},
\code{\link{ustfd_query}()},
\code{\link{ustfd_simple}()},
\code{\link{ustfd_table_columns}()}
}
\concept{ustfd_user}
