% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overhead.R
\name{overhead,USL-method}
\alias{overhead,USL-method}
\alias{overhead}
\title{Overhead method for Universal Scalability Law models}
\usage{
\S4method{overhead}{USL}(object, newdata)
}
\arguments{
\item{object}{A USL model object for which the overhead will be calculated.}

\item{newdata}{An optional data frame in which to look for variables
with which to calculate the overhead.
If omitted, the fitted values are used.}
}
\value{
\code{overhead} produces a matrix of overhead percentages based on
  a non-parallelized workload. The column \code{ideal} contains the ideal
  percentage of execution time. The columns \code{contention} and
  \code{coherency} give the additional overhead percentage caused by
  the respective effects.
}
\description{
\code{overhead} calculates the overhead in processing time for a system
modeled with the Universal Scalability Law.
It evaluates the regression function in the frame \code{newdata} (which
defaults to \code{model.frame(object)}). The result contains the ideal
processing time and the additional overhead caused by contention and
coherency delays.
}
\details{
The calculated processing times are given as percentages of a
non-parallelized workload. So for a non-parallelized workload the ideal
processing time will always be given as \emph{100\%} while the overhead
for contention and coherency will always be zero.

Doubling the capacity will cut the ideal processing time in half but
increase the overhead percentages. The increase of the overhead depends on
the values of the parameters \code{alpha} and \code{beta} estimated by
\code{\link{usl}}.

The calculation is based on \emph{A General Theory of Computational
Scalability Based on Rational Functions}, equation 26.
}
\examples{
require(usl)

data(specsdm91)

## Print overhead in processing time for demo dataset
overhead(usl(throughput ~ load, specsdm91))

}
\references{
Neil J. Gunther. Guerrilla Capacity Planning: A Tactical
  Approach to Planning for Highly Scalable Applications and Services.
  Springer, Heidelberg, Germany, 1st edition, 2007.

Neil J. Gunther. A General Theory of Computational Scalability
  Based on Rational Functions. Computing Research Repository, 2008.
  \code{http://arxiv.org/abs/0808.1431}
}
\seealso{
\code{\link{usl}}, \code{\link{USL-class}}
}
