% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{browse_github_pat}
\alias{browse_github_pat}
\title{Create a GitHub personal access token}
\usage{
browse_github_pat(scopes = c("repo", "gist"), description = "R:GITHUB_PAT",
  host = "https://github.com")
}
\arguments{
\item{scopes}{Character vector of token permissions. These are just defaults
that will be pre-selected in the web form. You can select the final values
on the GitHub page. Read more about GitHub API scopes at
\url{https://developer.github.com/apps/building-oauth-apps/scopes-for-oauth-apps/}.}

\item{description}{Short description or nickname for the token. It helps you
distinguish various tokens on GitHub.}

\item{host}{GitHub API host to use. Override with the endpoint-root for your
GitHub enterprise instance, for example,
"https://github.hostname.com/api/v3"}
}
\description{
Opens a browser window to the GitHub page where you can generate a \href{https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line}{Personal Access Token}.
Make sure you have signed up for a free \href{https://github.com/}{GitHub.com}
account and that you are signed in. Click "Generate token" after you have
verified the scopes. Copy the token right away! You probably want to store it
in \code{.Renviron} as the \code{GITHUB_PAT} environment variable. \code{\link[=edit_r_environ]{edit_r_environ()}}
can help you do that. Use \code{\link[gh:gh_whoami]{gh::gh_whoami()}} to get information on an existing
token.
}
\examples{
\dontrun{
browse_github_pat()
## COPY THE PAT!!!
## almost certainly to be followed by ...
edit_r_environ()
## which helps you store the PAT as an env var
}
}
