% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badge.R
\name{badges}
\alias{badges}
\alias{use_badge}
\alias{use_cran_badge}
\alias{use_bioc_badge}
\alias{use_depsy_badge}
\alias{use_lifecycle_badge}
\alias{use_binder_badge}
\title{README badges}
\usage{
use_badge(badge_name, href, src)

use_cran_badge()

use_bioc_badge()

use_depsy_badge()

use_lifecycle_badge(stage)

use_binder_badge()
}
\arguments{
\item{badge_name}{Badge name. Used in error message and alt text}

\item{href, src}{Badge link and image src}

\item{stage}{Stage of the package lifecycle}
}
\description{
These helpers produce the markdown text you need in your README to include
badges that report information, such as the CRAN version or test coverage,
and link out to relevant external resources.
}
\details{
\itemize{
\item \code{use_badge()}: a general helper used in all badge functions
\item \code{use_bioc_badge()}: badge indicates \href{http://bioconductor.org/developers/}{BioConductor build status}
\item \code{use_cran_badge()}: badge indicates what version of your package is
available on CRAN, powered by \url{https://www.r-pkg.org}
\item \code{use_depsy_badge()}: badge shows the "percentile overall impact" of the
project, powered by \url{http://depsy.org}, which only indexes projects that are
on CRAN
\item \code{use_lifecycle_badge()}: badge declares the developmental stage of a
package, according to \url{https://www.tidyverse.org/lifecycle/}:
\itemize{
\item Experimental
\item Maturing
\item Stable
\item Retired
\item Archived
\item Dormant
\item Questioning
}
\item \code{use_binder_badge()}: badge indicates that your repository can be launched
in an executable environment on \url{https://mybinder.org/}
}
}
\examples{
\dontrun{
use_cran_badge()
use_lifecycle_badge("stable")
}
}
\seealso{
The \link[=use_travis]{functions that set up continuous integration
services} also create badges.
}
