% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microservices.R
\name{add_service}
\alias{add_service}
\title{Add a Service Route to the Microservice}
\usage{
add_service(path = ".", name, overwrite = FALSE)
}
\arguments{
\item{path}{(\code{character}) Where is the project root folder?}

\item{name}{(\code{character}) what is the service route name? For example, if
\code{name} = "repository" then the set of services would become available
at \verb{http://127.0.0.1:8080/repository/}.}

\item{overwrite}{(\code{logical}) Should existing destination files be overwritten?}
}
\value{
No return value, called for side effects.
}
\description{
Add a Service Route to the Microservice
}
\details{
Lay the infrastructure for an additional set of services. That includes
adding a unit test, adding an endpoint, and extending the entrypointy.\if{html}{\out{
<div class="alert alert-warning">
}}


\strong{Note:} \code{add_service} adds a service to pre-existing plumber
microservice which you could deploy by calling \code{use_microservice}.\if{html}{\out{
</div>
}}

\subsection{How It Works}{

Given a \code{path} (.) to a folder and a \code{name} (repository)

When \code{add_service} is called

Then the function creates the following files:\if{html}{\out{<div class="r">}}\preformatted{tests/testthat/test-endpoint-plumber-repository.R
inst/endpoints/plumber-repository.R
}\if{html}{\out{</div>}}

And updates the following files:\if{html}{\out{<div class="r">}}\preformatted{inst/entrypoints/plumber-foreground.R
}\if{html}{\out{</div>}}
}

\subsection{When to Use}{

In scenarios where services are thematically linked to each other.
Examples for themes that should be mounted separately:
\itemize{
\item â€˜forecastingâ€™ and â€˜anomaly detectionâ€™
\item â€˜userâ€™ and â€˜businessâ€™
}
}
}
\examples{
path <- tempfile()
dir.create(path, showWarnings = FALSE, recursive = TRUE)
use_microservice(path)

add_service(path, name = "repository")

list.files(path, recursive = TRUE)
}
\seealso{
Other microservice utilities: 
\code{\link{use_microservice}()}
}
\concept{microservice utilities}
