% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{puny_encode}
\alias{puny_decode}
\alias{puny_encode}
\title{Encode or Decode Internationalised Domains}
\usage{
puny_encode(x)

puny_decode(x)
}
\arguments{
\item{x}{a vector of URLs. These should be URL decoded using \code{\link{url_decode}}.}
}
\value{
a CharacterVector containing encoded or decoded versions of the entries in \code{x}.
Invalid URLs (ones that are \code{NA}, or ones that do not successfully map to an actual
decoded or encoded version) will be returned as \code{NA}.
}
\description{
\code{puny_encode} and \code{puny_decode} implement
the encoding standard for internationalised (non-ASCII) domains and
subdomains. You can use them to encode UTF-8 domain names, or decode
encoded names (which start "xn--"), or both.
}
\examples{
# Encode a URL
puny_encode("https://www.bücher.com/foo")

# Decode the result, back to the original
puny_decode("https://www.xn--bcher-kva.com/foo")

}
\seealso{
\code{\link{url_decode}} and \code{\link{url_encode}} for percent-encoding.
}

