% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{GFF}
\alias{GFF}
\title{Twin data: General Family Functioning, divorce, and well-being.}
\format{
A data frame with 1000 rows of twin-family data columns.
}
\usage{
data(GFF)
}
\description{
Measures of family functioning, happiness and related variables in twins, and
their brothers and sisters. (see details)
}
\details{
Several scales in the data are described in  van der Aa et al. (2010).
General Family Functioning (GFF) refers to adolescents' evaluations general family health
vs. pathology. It assesses problem solving, communication, roles within the household,
affection, and control. GFF was assessed with a Dutch translation of the General Functioning
sub-scale of the McMaster Family Assessment Device (FAD) (Epstein et al., 1983).

Family Conflict (FC) refers to adolescents' evaluations of the amount of openly
expressed anger, aggression, and conflict among family members. Conflict
sub-scale of the Family Environment Scale (FES) (Moos, 1974)

Quality of life in general (QLg) was assessed with the 10-step Cantril
Ladder from best- to worst-possible life (Cantril, 1965).
\itemize{
\item \emph{zyg_6grp}: Six-level zygosity: MZMM, DZMM, MZFF, DZFF, DZMF, DZFM
\item \emph{zyg_2grp}: Two-level zygosity measure: 'MZ', 'DZ'
\item \emph{divorce}: Parental divorce status: 0 = No, 1 = Yes
\item \emph{sex_T1}: Sex of twin 1: 0 = "male", 1 = "female"
\item \emph{age_T1}: Age of twin 1 (years)
\item \emph{gff_T1}: General family functioning for twin 1
\item \emph{fc_T1}: Family conflict sub-scale of the FES
\item \emph{qol_T1}: Quality of life for twin 1
\item \emph{hap_T1}: General happiness for twin 1
\item \emph{sat_T1}: Satisfaction with life for twin 1
\item \emph{AD_T1}: Anxiety and Depression for twin 1
\item \emph{SOMA_T1}: Somatic complaints for twin 1
\item \emph{SOC_T1}: Social problems for twin 1
\item \emph{THOU_T1}: Thought disorder problems for twin 1
\item \emph{sex_T2}: Sex of twin 2
\item \emph{age_T2}: Age of twin 2
\item \emph{gff_T2}: General family functioning for twin 2
\item \emph{fc_T2}: Family conflict sub-scale of the FES
\item \emph{qol_T2}: Quality of life for twin 2
\item \emph{hap_T2}: General happiness for twin 2
\item \emph{sat_T2}: Satisfaction with life for twin 2
\item \emph{AD_T2}: Anxiety and Depression for twin 2
\item \emph{SOMA_T2}: Somatic complaints for twin 2
\item \emph{SOC_T2}: Social problems for twin 2
\item \emph{THOU_T2}: Thought disorder problems for twin 2
\item \emph{sex_Ta}: Sex of sib 1
\item \emph{age_Ta}: Age of sib 1
\item \emph{gff_Ta}: General family functioning for sib 1
\item \emph{fc_Ta}: Family conflict sub-scale of the FES
\item \emph{qol_Ta}: Quality of life for sib 1
\item \emph{hap_Ta}: General happiness for sib 1
\item \emph{sat_Ta}: Satisfaction with life for sib 1
\item \emph{AD_Ta}: Anxiety and Depression for sib 1
\item \emph{SOMA_Ta}: Somatic complaints for sib 1
\item \emph{SOC_Ta}: Social problems for sib 1
\item \emph{THOU_Ta}: Thought disorder problems for sib 1
\item \emph{sex_Ts}: Sex of sib 2
\item \emph{age_Ts}: Age of sib 2
\item \emph{gff_Ts}: General family functioning for sib 2
\item \emph{fc_Ts}: Family conflict sub-scale of the FES
\item \emph{qol_Ts}: Quality of life for sib 2
\item \emph{hap_Ts}: General happiness for sib 2
\item \emph{sat_Ts}: Satisfaction with life for sib 2
\item \emph{AD_Ts}: Anxiety and Depression for sib 2
\item \emph{SOMA_Ts}: Somatic complaints for sib 2
\item \emph{SOC_Ts}: Social problems for sib 2
\item \emph{THOU_Ts}: Thought disorder problems for sib 2
}
}
\examples{
\dontrun{
# Twin 1 variables (end in '_T1')
data(GFF)
umx_names(GFF, "1$") # Just variables ending in 1 (twin 1)
str(GFF) # first few rows


m1 = umxACE(selDVs= "gff", sep = "_T",
	mzData = subset(GFF, zyg_2grp == "MZ"), 
	dzData = subset(GFF, zyg_2grp == "DZ")
)
}

}
\references{
van der Aa, N., Boomsma, D. I., Rebollo-Mesa, I., Hudziak, J. J., & Bartels,
M. (2010). Moderation of genetic factors by parental divorce in adolescents'
evaluations of family functioning and subjective wellbeing. Twin Research
and Human Genetics, \strong{13}, 143-162. \doi{10.1375/twin.13.2.143}
}
\seealso{
Other datasets: 
\code{\link{Fischbein_wt}},
\code{\link{docData}},
\code{\link{iqdat}},
\code{\link{umx}},
\code{\link{us_skinfold_data}}
}
\concept{datasets}
\keyword{datasets}
