% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_fit_umxPlotCPnew.R
\name{umxPlotCPnew}
\alias{umxPlotCPnew}
\title{Draw and display a graphical figure of Common Pathway model}
\usage{
umxPlotCPnew(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, format = c("current", "graphviz", "DiagrammeR"),
  SEstyle = FALSE, strip_zero = TRUE, ...)
}
\arguments{
\item{x}{The Common Pathway \code{\link{mxModel}} to display graphically}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{SEstyle}{report "b (se)" instead of b CI95[l, u] (Default = FALSE)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Optional additional parameters}
}
\value{
- Optionally return the dot code
}
\description{
Options include digits (rounding), showing means or not, and which output format is desired.
}
\details{
# @aliases plot.MxModelCP
}
\examples{
\dontrun{
require(umx)
umx_set_optimizer("SLSQP")
data(GFF)
mzData = subset(GFF, zyg_2grp == "MZ")
dzData = subset(GFF, zyg_2grp == "DZ")
selDVs = c("gff", "fc", "qol", "hap", "sat", "AD") 
m1 = umxCP("new", selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData, 
	nFac = 3, correlatedA = TRUE
)
m1 = mxTryHardOrdinal(m1)
umxPlotCPnew(m1)
plot(m1) # no need to remember a special name: plot works fine!
}
}
\references{
- \url{https://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxCP}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxEbiv}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxPlotSimplex}},
  \code{\link{umx}}
}
\concept{Plotting functions}
