% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxGxE_window}
\alias{umxGxE_window}
\title{Implement the moving-window form of GxE analysis.}
\usage{
umxGxE_window(selDVs = NULL, moderator = NULL, mzData = mzData,
  dzData = dzData, suffix = NA, weightCov = FALSE, target = NULL,
  width = 1, plotWindow = FALSE, return = c("estimates", "last_model"))
}
\arguments{
\item{selDVs}{The dependent variables for T1 and T2, e.g. c("bmi_T1", "bmi_T2")}

\item{moderator}{The name of the moderator variable in the dataset e.g. "age", "SES" etc.}

\item{mzData}{Dataframe containing the DV and moderator for MZ twins}

\item{dzData}{Dataframe containing the DV and moderator for DZ twins}

\item{suffix}{(optional) separator, e.g. "_T" which will be used expand base names into full variable names:
e.g.: 'bmi' --> c("bmi_T1", "bmi_T2")}

\item{weightCov}{Whether to use cov.wt matrices or FIML default = FALSE, i.e., FIML}

\item{target}{A user-selected list of moderator values to test (default = NULL = explore the full range)}

\item{width}{An option to widen or narrow the window from its default (of 1)}

\item{plotWindow}{whether to plot what the window looks like}

\item{return}{whether to return the last model (useful for specifiedTargets) or the list of estimates (default = "estimates")}
}
\value{
- Table of estimates of ACE along the moderator
}
\description{
Make a 2-group GxE (moderated ACE) model using LOSEM. In GxE interaction studies, typically,
the hypothesis that the strength of genetic influence varies parametrically (usually linear effects
on path estimates) across levels of environment. Of course, the function linking genetic influence
and context is not necessarily linear, but may react more steeply at the extremes, or take other, unknown forms.
To avoid obscuring the underlying shape of the interaction effect, local structural equation
modeling (LOSEM) may be used, and GxE_window implements this. LOSEM is a non-parametric,
estimating latent interaction effects across the range of a measured moderator using a
windowing function which is walked along the context dimension, and which weights subjects
near the center of the window highly relative to subjects far above or below the window center.
This allows detecting and visualizing arbitrary GxE (or CxE or ExE) interaction forms.
}
\examples{
library(umx);
# ==============================
# = 1. Open and clean the data =
# ==============================
# umxGxE_window takes a dataframe consisting of a moderator and two DV columns: one for each twin.
# The model assumes two groups (MZ and DZ). Moderator can't be missing
mod = "age" # The name of the moderator column in the dataset
selDVs = c("bmi1", "bmi2") # The DV for twin 1 and twin 2
data(twinData) # Dataset of Australian twins, built into OpenMx
# The twinData consist of two cohorts: "younger" and "older".
# zygosity is a factor. levels =  MZFF, MZMM, DZFF, DZMM, DZOS.
# Delete missing moderator rows
twinData = twinData[!is.na(twinData[mod]), ]
mzData = subset(twinData, zygosity == "MZFF", c(selDVs, mod))
dzData = subset(twinData, zygosity == "DZFF", c(selDVs, mod))

# ========================
# = 2. Run the analyses! =
# ========================
# Run and plot for specified windows (in this case just 1927)
umxGxE_window(selDVs = selDVs, moderator = mod, mzData = mzData, dzData = dzData, 
		target = 40, plotWindow = TRUE)

\dontrun{
# Run with FIML (default) uses all information
umxGxE_window(selDVs = selDVs, moderator = mod, mzData = mzData, dzData = dzData);

# Run creating weighted covariance matrices (excludes missing data)
umxGxE_window(selDVs = selDVs, moderator = mod, mzData = mzData, dzData = dzData, 
		weightCov = TRUE); 
}

}
\references{
- Hildebrandt, A., Wilhelm, O, & Robitzsch, A. (2009)
Complementary and competing factor analytic approaches for the investigation 
of measurement invariance. \emph{Review of Psychology}, \bold{16}, 87--107. 

Briley, D.A., Harden, K.P., Bates, T.C.,  Tucker-Drob, E.M. (2015).
Nonparametric Estimates of Gene x Environment Interaction Using Local Structural Equation Modeling.
\emph{Behavior Genetics}.
}
\seealso{
Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCPold}},
  \code{\link{umxCP}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPnew}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
