% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_show}
\alias{umx_show}
\title{umx_show}
\usage{
umx_show(model, what = c("values", "free", "labels", "nonzero_or_free"),
  show = c("all", "free", "fixed"), matrices = c("S", "A"), digits = 2)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to show data from}

\item{what}{legal options are "values" (default), "free", or "labels")}

\item{show}{filter on what to show c("all", "free", "fixed")}

\item{matrices}{to show  (default is c("S", "A")). "Thresholds" in beta}

\item{digits}{precision to report, defaults to rounding to 2 decimal places}
}
\value{
- \code{\link{mxModel}}
}
\description{
Show matrix contents. The user can select  values, free, and/or labels, and which matrices to display
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
umx_show(m1)
umx_show(m1, digits = 3)
umx_show(m1, matrices = "S")
umx_show(m1, what = "free")
umx_show(m1, what = "labels")
umx_show(m1, what = "free", matrices = "A")
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_print}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
