% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umxCovData}
\alias{umxCovData}
\title{Convert a dataframe into a cov mxData object}
\usage{
umxCovData(df, columns = NA, use = c("complete.obs", "everything",
  "all.obs", "na.or.complete", "pairwise.complete.obs"))
}
\arguments{
\item{df}{the dataframe to covert to an mxData type cov object.}

\item{columns}{= Which columns to keep (default is all).}

\item{use}{= Default is "complete.obs".}
}
\value{
- \code{\link{mxData}} of type = cov
}
\description{
umxCovData converts a dataframe into an mxData, taking the covariance, defaulting to nrow as the numObs,
and optionally adding means.
}
\examples{
umxCovData(mtcars, c("mpg", "hp"))
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Data Functions: \code{\link{umxFactor}},
  \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_array_shift}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}}, \code{\link{umx_pad}},
  \code{\link{umx_read_lower}}, \code{\link{umx_rename}},
  \code{\link{umx_reorder}}, \code{\link{umx_scale}},
  \code{\link{umx_stack}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}
