% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{umap}
\alias{umap}
\title{Computes a manifold approximation and projection}
\usage{
umap(d, config = umap.defaults, method = c("naive", "umap-learn"), ...)
}
\arguments{
\item{d}{matrix, input data}

\item{config}{object of class umap.config}

\item{method}{character, implementation. Available methods are 'naive'
(an implementation written in pure R) and 'umap-learn' (requires python
package 'umap-learn')}

\item{...}{list of settings; overwrite default values from config}
}
\value{
object of class umap, containing at least a component
with an embedding and a component with configuration settings
}
\description{
Computes a manifold approximation and projection
}
\examples{
# embedd iris dataset using default settings
iris.umap = umap(iris[,1:4])

# display object summary
iris.umap

# display embedding coordinates
head(iris.umap$layout)

}
