% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe_train.R
\name{udpipe_accuracy}
\alias{udpipe_accuracy}
\title{Evaluate the accuracy of your UDPipe model on holdout data}
\usage{
udpipe_accuracy(object, file_conllu, tokenizer = c("default", "none"),
  tagger = c("default", "none"), parser = c("default", "none"))
}
\arguments{
\item{object}{an object of class \code{udpipe_model} as returned by \code{\link{udpipe_load_model}}}

\item{file_conllu}{the full path to a file on disk containing holdout data in conllu format}

\item{tokenizer}{a character string of length 1, which is either 'default' or 'none'}

\item{tagger}{a character string of length 1, which is either 'default' or 'none'}

\item{parser}{a character string of length 1, which is either 'default' or 'none'}
}
\value{
a list with 3 elements
\itemize{
 \item{accuracy: }{A character vector with accuracy metrics.}
 \item{error: }{A character string with possible errors when calculating the accuracy metrics}
}
}
\description{
Get precision, recall and F1 measures on finding words / sentences / upos / xpos / features
annotation as well as UAS and LAS dependency scores on holdout data in conllu format.
}
\examples{
x <- udpipe_download_model(language = "dutch-lassysmall")
ud_dutch <- udpipe_load_model(x$file_model)

file_conllu <- system.file(package = "udpipe", "dummydata", "traindata.conllu")
metrics <- udpipe_accuracy(ud_dutch, file_conllu)
metrics$accuracy
metrics <- udpipe_accuracy(ud_dutch, file_conllu, 
                           tokenizer = "none", tagger = "default", parser = "default")
metrics$accuracy
metrics <- udpipe_accuracy(ud_dutch, file_conllu, 
                           tokenizer = "none", tagger = "none", parser = "default")
metrics$accuracy
metrics <- udpipe_accuracy(ud_dutch, file_conllu, 
                           tokenizer = "default", tagger = "none", parser = "none")
metrics$accuracy

## cleanup for CRAN only - you probably want to keep your model if you have downloaded it
file.remove("dutch-lassysmall-ud-2.0-170801.udpipe")
}
\references{
\url{https://ufal.mff.cuni.cz/udpipe}, 
\url{http://universaldependencies.org/format.html}
}
\seealso{
\code{\link{udpipe_load_model}}
}
