% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe_models.R
\name{udpipe_load_model}
\alias{udpipe_load_model}
\title{Load an UDPipe model}
\usage{
udpipe_load_model(file)
}
\arguments{
\item{file}{full path to the model}
}
\value{
An object of class \code{udpipe_model} which is a list with 2 elements
\itemize{
 \item{file: }{The path to the model as provided by \code{file}}
 \item{model: }{An Rcpp-generated pointer to the loaded model which can be used in \code{\link{udpipe_annotate}}}
}
}
\description{
Load an UDPipe model
}
\examples{
x <- udpipe_download_model(language = "dutch-lassysmall", model_dir = tempdir())
x$file_model
ud_dutch <- udpipe_load_model(x$file_model)
\dontrun{
x <- udpipe_download_model(language = "english")
x$file_model
ud_english <- udpipe_load_model(x$file_model)

x <- udpipe_download_model(language = "hebrew")
x$file_model
ud_hebrew <- udpipe_load_model(x$file_model)
}
}
\references{
\url{https://ufal.mff.cuni.cz/udpipe}, \url{https://lindat.mff.cuni.cz/repository/xmlui/handle/11234/1-2364}
}
\seealso{
\code{\link{udpipe_annotate}}, \code{\link{udpipe_download_model}}, \code{\link{udpipe_train}}
}
