% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colext.R
\name{stan_colext}
\alias{stan_colext}
\title{Fit the MacKenzie et al. (2003) Dynamic Occupancy Model}
\usage{
stan_colext(
  psiformula = ~1,
  gammaformula = ~1,
  epsilonformula = ~1,
  pformula = ~1,
  data,
  ...
)
}
\arguments{
\item{psiformula}{Right-hand sided formula for the initial probability of
occupancy at each site}

\item{gammaformula}{Right-hand sided formula for colonization probability}

\item{epsilonformula}{Right-hand sided formula for extinction probability}

\item{pformula}{Right-hand sided formula for detection probability}

\item{data}{A \code{\link{unmarkedMultFrame}} object}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitColext} object describing the model fit.
}
\description{
This function fits the dynamic occupancy model of
MacKenzie et al. (2003).
}
\examples{
\donttest{
data(frogs)
umf <- formatMult(masspcru)
umf@y[umf@y > 1] <- 1 #convert counts to presence/absence
umf <- umf[1:100,] #Use only 100 sites

fit_frog <- stan_colext(~1, ~1, ~1, ~1, umf, chains=3, iter=300)
}

}
\references{
MacKenzie DI, Nicholas JD, Hines JE, Knutson MG, Franklin AB.
            2003. Ecology 84: 2200-2207.
}
\seealso{
\code{\link{colext}}, \code{\link{unmarkedMultFrame}}
}
