% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_twb_from_twbx}
\alias{extract_twb_from_twbx}
\title{Extract the .twb (and optionally all files) from a .twbx}
\usage{
extract_twb_from_twbx(
  twbx_path,
  extract_dir = file.path(tempdir(), paste0("twbx_",
    tools::file_path_sans_ext(basename(twbx_path)), "_", format(Sys.time(),
    "\%Y\%m\%d\%H\%M\%S"))),
  extract_all = FALSE
)
}
\arguments{
\item{twbx_path}{Path to a \code{.twbx} file.}

\item{extract_dir}{Directory to extract into (defaults to a timestamped temp dir).}

\item{extract_all}{If \code{TRUE}, extract entire archive; otherwise only the largest \code{.twb}.}
}
\value{
List with \code{twb_path}, \code{exdir}, \code{twbx_path}, and \code{manifest} (tibble).
}
\description{
Extract the .twb (and optionally all files) from a .twbx
}
\examples{
\dontshow{if (nzchar(system.file("extdata", "test_for_zip.twbx", package = "twbparser"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
twbx <- system.file("extdata", "test_for_zip.twbx", package = "twbparser")
res  <- extract_twb_from_twbx(twbx, extract_all = FALSE)
basename(res$twb_path)
\dontshow{\}) # examplesIf}
}
