% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_tubfs.R
\name{plot.tuts_BFS}
\alias{plot.tuts_BFS}
\title{Plots and visual diagnostics of tuts_BFS objects}
\usage{
\method{plot}{tuts_BFS}(x, type, ...)
}
\arguments{
\item{x}{A tuts_BFS objects.}

\item{type}{plot type with the following options:\cr
- 'periodogram' plots estimates of power spectrum.  \cr
- 'predTUTS' plots one step predictions of the model. \cr
- 'GR' plots Gelman-Rubin diagnostics. \cr
- 'cv' plots 5-fold cross validation. \cr
- 'mcmc' plots diagnostics of MCMC/JAGS objects. \cr
- 'volatility' plots volatility realizations. \cr}

\item{...}{list of optional parameters:\cr
- burn: burn-in parameter ranging from 0 to 0.7 with default value set to 0. \cr
- CI: credible interval ranging from 0.3 to 1 with default value set to 0.95.}
}
\description{
\code{plot.tuts_BFS} generates plots and visual diagnostics of tuts_BFS objects.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN’s testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=5,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the model:
n.sim=10
BFS=tubfs(y=y,ti.mu=ti.mu,ti.sd=ti.sd,freqs='internal',n.sim=n.sim,n.chains=2, CV=TRUE,n.cores=2)

#3. Generate plots and diagnostics of the model (optional parameters are listed in brackets):
plot(BFS,type='periodogram')               # spectral analysis (CI, burn).
plot(BFS,type='predTUTS', CI=0.99)         # One step predictions (CI, burn).
plot(BFS,type='cv')                        # 5 fold cross validation plot (CI, burn).
plot(BFS,type='GR')                        # Gelman-Rubin diagnostics (CI, burn).
plot(BFS,type='mcmc')                      # mcmc diagnostics.
plot(BFS,type='volatility')                # Volatility realizaitons.
}
