% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_videos.R
\name{list_videos}
\alias{list_videos}
\title{List (Most Popular) Videos}
\usage{
list_videos(
  part = "contentDetails",
  max_results = 50,
  page_token = NULL,
  hl = NULL,
  region_code = NULL,
  video_category_id = NULL,
  ...
)
}
\arguments{
\item{part}{Required. Comma separated string including one or more of the
following: \code{contentDetails,
fileDetails, id, liveStreamingDetails, localizations, player,
processingDetails, recordingDetails,
snippet, statistics, status, suggestions, topicDetails}. Default:
\code{contentDetails}.}

\item{max_results}{Maximum number of items that should be returned. Integer.
Optional. Can be between 0 and 50. Default is 50.}

\item{page_token}{specific page in the result set that should be returned,
optional}

\item{hl}{Language used for text values. Optional. Default is \code{en-US}.
For other allowed language codes, see \code{\link{list_langs}}.}

\item{region_code}{Character. Required. Has to be a ISO 3166-1 alpha-2 code
(see \url{https://www.iso.org/obp/ui/#search}).}

\item{video_category_id}{the video category for which the chart should be
retrieved. See also \code{\link{list_videocats}}.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
data.frame with 5 columns: \code{channelId, title, assignable, etag, id}
}
\description{
List (Most Popular) Videos
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

list_videos()
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/search/list}
}
