% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOptK.R
\name{getOptK}
\alias{getOptK}
\title{Optimal temporal aggregation level for AR(1), MA(1), ARMA(1,1)}
\usage{
getOptK(y, m = 12, type = c("ar", "ma", "arma"))
}
\arguments{
\item{y}{a time series that must be of either \code{ts} or \code{msts} class.}

\item{m}{maximum aggregation level.}

\item{type}{type of data generating process. Can be:
\itemize{
\item{\code{"ar"}}{: For AR(1) series.}
\item{\code{"ma"}}{: For MA(1) series.}
\item{\code{"arma"}}{: For ARMA(1,1) series.}
}}
}
\value{
Identified optimal temporal aggregation level.
}
\description{
Calculate the theoretically optimal temporal aggregation level for AR(1), MA(1) and ARMA(1,1) time series.
}
\examples{
getOptK(referrals)

}
\references{
\itemize{
\item{Kourentzes, N., Rostami-Tabar, B., & Barrow, D. K. (2017). \href{https://kourentzes.com/forecasting/2017/04/22/demand-forecasting-by-temporal-aggregation-using-optimal-or-multiple-aggregation-levels/}{Demand forecasting by temporal aggregation: using optimal or multiple aggregation levels?}. Journal of Business Research, 78, 1-9.}
\item{Rostami-Tabar, B., Babai, M. Z., Syntetos, A., & Ducq, Y. (2013). Demand forecasting by temporal aggregation. Naval Research Logistics (NRL), 60(6), 479-498.}
\item{Rostami-Tabar, B., Babai, M. Z., Syntetos, A., & Ducq, Y. (2014). A note on the forecast performance of temporal aggregation. Naval Research Logistics (NRL), 61(7), 489-500.}
}
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{htest}
