% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxstuart.R
\name{coxstuart}
\alias{coxstuart}
\title{Cox-Stuart test}
\usage{
coxstuart(y, type = c("trend", "deviation", "dispersion"),
  alpha = 0.05)
}
\arguments{
\item{y}{input data.}

\item{type}{type of test. Can be:
\itemize{
\item{\code{"trend"}}{: test for changes in trend.}
\item{\code{"deviation"}}{: test for changes in deviation.}
\item{\code{"dispersion"}}{: test for changes in dispersion (range).}
}}

\item{alpha}{significance level.}
}
\value{
A list containing:
\itemize{
\item{\code{H}}{: hypothesis outcome.}
\item{\code{p.value}}{: corresponding p-value.}
\item{\code{Htxt}}{: textual description of the hypothesis outcome.}
}
}
\description{
Perform Cox-Stuart test for location or dispersion.
}
\examples{
coxstuart(referrals)

}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{htest}
